<?php
/*
 *  Copyright (c) 2024 Borlabs GmbH. All rights reserved.
 *  This file may not be redistributed in whole or significant part.
 *  Content of this file is protected by international copyright laws.
 *
 *  ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 *  @copyright Borlabs GmbH, https://borlabs.io
 */

declare(strict_types=1);

namespace Borlabs\Cookie\Localization;

use function Borlabs\Cookie\System\WordPressGlobalFunctions\_x;

/**
 * The **GlobalLocalizationStrings** class contains various localized strings.
 *
 * @see \Borlabs\Cookie\Localization\GlobalLocalizationStrings::get()
 */
final class WordPressAdminInitLocalizationStrings implements LocalizationInterface
{
    /**
     * @return array<array<string>>
     */
    public static function get(): array
    {
        return [
            // Alert messages
            'alert' => [
                'borlabsCookieNotActive' => _x(
                    '<translation-key id="Borlabs-Cookie">Borlabs Cookie</translation-key> is not active. If you want to use <translation-key id="Borlabs-Cookies">Borlabs Cookie\'s</translation-key> features on your website, please activate it under <translation-key id="Navigation-Settings">Settings</translation-key> &raquo; <translation-key id="Borlabs-Cookie-Status">Borlabs Cookie Status</translation-key>.',
                    'Backend / Init / Alert Message',
                    'borlabs-cookie',
                ),
            ],

            // Plugin links
            'pluginLinks' => [
                'dashboard' => _x(
                    'Dashboard',
                    'Backend / Init / Plugin Links',
                    'borlabs-cookie',
                ),
                'license' => _x(
                    'License',
                    'Backend / Init / Plugin Links',
                    'borlabs-cookie',
                ),
                'settings' => _x(
                    'Settings',
                    'Backend / Init / Plugin Links',
                    'borlabs-cookie',
                ),
            ],
        ];
    }
}
